var publicFun={ 
	windowUrl:window.location.href,
	//js注入
	injectCustomJS(jsPath) {
		jsPath = jsPath || 'js/inject.js';
		var temp = document.createElement('script');
		temp.setAttribute('type', 'text/javascript');
		temp.src = chrome.extension.getURL(jsPath);
		temp.onload = function() {
			this.remove(); //执行完移除
		};
		document.body.appendChild(temp);
	},
	//css注入
	injectCustomCss(cssPath) {
		var link = document.createElement("link");
		link.href = chrome.extension.getURL(cssPath);
		link.type = "text/css";
		link.rel = "stylesheet";
		document.getElementsByTagName("head")[0].appendChild(link);
	},
	ajax(set){
		let m = this;
		
		let op={ 
			url:		set.url, 
			params:		set.params||{}, 
			type:		set.type||"post", 
			success:	set.success||function(){}, 
			error:		set.error||function(){},
			isAsync:	set.isAsync!=false?true:false,
			isJSON:		set.isJSON==false?false:true
		}
		
		if(op.isJSON &&Object.keys(op.params).length!=0){
			op.params=JSON.stringify(op.params)
		}
		
		var ajaxOp = {
			// crossDomain:true,
			headers: {
				"Content-Type":'application/json;charset=UTF-8',
			},
			url: op.url,
			dataType: "json",
			async: op.isAsync,
			type: op.type,
			data: op.params,
			success: function(res) {
				op.success(res)
			},
			error: function(err) {
				op.error(err)
			}
		}
		$.ajax(ajaxOp)
	},
	 //时间戳转日期
	timestampToTime(timestamp,type) {
		var date = new Date(timestamp * 1000);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
		var Y = date.getFullYear() + '-';
		var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
		var D = (date.getDate()<10?"0"+date.getDate():date.getDate()) ;
		var h = (date.getHours()<10?"0"+date.getHours():date.getHours()) + ':';
		var m = (date.getMinutes()<10?"0"+date.getMinutes():date.getMinutes()) + ':';
		var s = (date.getSeconds()<10?"0"+date.getSeconds():date.getSeconds());
		if(type=="date"){//只返回日期
			return Y + M + D+" 00:00:00";
		}
		if(type=="putReadDate"){
			return Y + M + D +"T"+ h + m + s;
		}
		return Y + M + D+ ' ' + h + m + s;
	},
	//开始月份往前推
	getMonthPreDate(pre,date){
		let m=this;
		pre=(pre!=undefined?pre:0)
		var myDate = new Date();
		var year = myDate.getFullYear();//本年
		var month = myDate.getMonth()+1;//本月
		if(date){
			myDate=new Date(date)
		}
		if(month>pre){
			month=month-pre
		}else{
			month=month+12-pre
			year=year-1;
		}
		if(month<0){
			month="0"+month
		}
		let thisDate = year+'-'+month+'-01 00:00:00';
		return thisDate
	},
	//获取从date日开始的  pre天之后 可以负数
	getPreDate: function(pre,date) {
	  var self = this;
	  var c = new Date();
	  if(date){
	      c=new Date(date)
	  }
	  c.setDate(c.getDate() - pre);
	  return self.formatDate(c);
	},
	formatDate: function(d) {
	  var self = this;
	  return d.getFullYear() + "-" + self.getMonth1(d.getMonth()) + "-" + self.getMonth1(d.getDate(), "getDate")
	},
	getMonth1: function(m,type) {
	  var self = this;
	  if (type != "getDate") {
	    m++;
	  }
	  if (m < 10)
	    return "0" + m.toString();
	  return m.toString();
	},
	//获取超链接参数
	getUrlParamgetUrlParam(name) {
		
		var sValue = location.search.match(new RegExp("[\?\&]" + name + "=([^\&]*)(\&?)", "i"));
		return sValue ? sValue[1] : sValue;
	},
	//自定意的链接
	getUrlParam(url,name){
	    var pattern = new RegExp("[?&]" + name +"\=([^&]+)","g");
	    var matcher = pattern.exec(url);
	    var items = null;
	    if(matcher != null){
	        try{
	            items = decodeURIComponent(decodeURIComponent(matcher[1]));
	        }catch(e){
	            try{
	                items = decodeURIComponent(matcher[1]);
	            }catch(e){
	                items = matcher[1];
	            }
	        }
	    }
	    return items;
	},
	//年月日时分秒
	getCurrentDate(format) {
		var now = new Date();
		var year = now.getFullYear(); //得到年份
		var month = now.getMonth(); //得到月份
		var date = now.getDate(); //得到日期
		var day = now.getDay(); //得到周几
		var hour = now.getHours(); //得到小时
		var minu = now.getMinutes(); //得到分钟
		var sec = now.getSeconds(); //得到秒
		month = month + 1;
		if (month < 10) month = "0" + month;
		if (date < 10) date = "0" + date;
		if (hour < 10) hour = "0" + hour;
		if (minu < 10) minu = "0" + minu;
		if (sec < 10) sec = "0" + sec;
		var time = "";
		//精确到天
		if (format == 1) {
			time = year + "-" + month + "-" + date;
		}
		//精确到分
		else if (format == 2) {
			time = year + "-" + month + "-" + date + " " + hour + ":" + minu + ":" + sec;
		}
		return time;
	},
	paramsToPath(data) {
		var _result = [];
	
		for (var key in data) {
			var value = data[key];
			if (value.constructor == Array) {
				value.forEach(function(_value) {
					_result.push(key + "=" + _value);
				});
			} else {
				_result.push(key + '=' + value);
			}
		}
		return _result.join('&');
	},
	//时间戳转年月日  
	getDate(str){
		let self=this;
		str=parseInt(str+"000")
		var date = new Date(str);
		Y = date.getFullYear() + '-';
		M = (date.getMonth()+1 < 10 ? '0'+(date.getMonth()+1) : date.getMonth()+1) + '-';
		D = date.getDate() + ' ';
		h = date.getHours() + ':';
		m = date.getMinutes() + ':';
		s = date.getSeconds(); 
	    return Y+M+self.getzf(D);  
	},
	//补0操作  
	getzf(num){  
		let m=this;
		if(parseInt(num) < 10){  
			num = '0'+num;  
		}  
		return num;  
	},
	//获取指定COOKIES
	getCookie(cname){
	  var name = cname + "=";
	  var ca = document.cookie.split(';');
	  for(var i=0; i<ca.length; i++) 
	  {
	    var c = ca[i].trim();
	    if (c.indexOf(name)==0) return c.substring(name.length,c.length);
	  }
	  return "";
	},
	//设置Cookie
	setCookie(cname,cvalue,exdays){
	  var d = new Date();
	  d.setTime(d.getTime()+(exdays*24*60*60*1000));
	  var expires = "expires="+d.toGMTString();
	  document.cookie = cname + "=" + cvalue + "; " + expires;
	},
	//删除Cookie
	removeCookie(cname){
		document.cookie = cname+"=; expires=Thu, 01 Jan 1970 00:00:00 GMT";
	}
}
function script_base64(){
		// private property  
		_keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";  
	
		// public method for encoding  
		this.encode = function (input) {  
			var output = "";  
			var chr1, chr2, chr3, enc1, enc2, enc3, enc4;  
			var i = 0;  
			input = _utf8_encode(input);  
			while (i < input.length) {  
				chr1 = input.charCodeAt(i++);  
				chr2 = input.charCodeAt(i++);  
				chr3 = input.charCodeAt(i++);  
				enc1 = chr1 >> 2;  
				enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);  
				enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);  
				enc4 = chr3 & 63;  
				if (isNaN(chr2)) {  
					enc3 = enc4 = 64;  
				} else if (isNaN(chr3)) {  
					enc4 = 64;  
				}  
				output = output +  
				_keyStr.charAt(enc1) + _keyStr.charAt(enc2) +  
				_keyStr.charAt(enc3) + _keyStr.charAt(enc4);  
			}  
			return output;  
		}  
	
		// public method for decoding  
		this.decode = function (input) {  
			var output = "";  
			var chr1, chr2, chr3;  
			var enc1, enc2, enc3, enc4;  
			var i = 0;  
			input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");  
			while (i < input.length) {  
				enc1 = _keyStr.indexOf(input.charAt(i++));  
				enc2 = _keyStr.indexOf(input.charAt(i++));  
				enc3 = _keyStr.indexOf(input.charAt(i++));  
				enc4 = _keyStr.indexOf(input.charAt(i++));  
				chr1 = (enc1 << 2) | (enc2 >> 4);  
				chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);  
				chr3 = ((enc3 & 3) << 6) | enc4;  
				output = output + String.fromCharCode(chr1);  
				if (enc3 != 64) {  
					output = output + String.fromCharCode(chr2);  
				}  
				if (enc4 != 64) {  
					output = output + String.fromCharCode(chr3);  
				}  
			}  
			output = _utf8_decode(output);  
			return output;  
		}  
	
		// private method for UTF-8 encoding  
		_utf8_encode = function (string) {  
			string = string.replace(/\r\n/g,"\n");  
			var utftext = "";  
			for (var n = 0; n < string.length; n++) {  
				var c = string.charCodeAt(n);  
				if (c < 128) {  
					utftext += String.fromCharCode(c);  
				} else if((c > 127) && (c < 2048)) {  
					utftext += String.fromCharCode((c >> 6) | 192);  
					utftext += String.fromCharCode((c & 63) | 128);  
				} else {  
					utftext += String.fromCharCode((c >> 12) | 224);  
					utftext += String.fromCharCode(((c >> 6) & 63) | 128);  
					utftext += String.fromCharCode((c & 63) | 128);  
				}  
	
			}  
			return utftext;  
		}  
	
		// private method for UTF-8 decoding  
		_utf8_decode = function (utftext) {  
			var string = "";  
			var i = 0;  
			var c = c1 = c2 = 0;  
			while ( i < utftext.length ) {  
				c = utftext.charCodeAt(i);  
				if (c < 128) {  
					string += String.fromCharCode(c);  
					i++;  
				} else if((c > 191) && (c < 224)) {  
					c2 = utftext.charCodeAt(i+1);  
					string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));  
					i += 2;  
				} else {  
					c2 = utftext.charCodeAt(i+1);  
					c3 = utftext.charCodeAt(i+2);  
					string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));  
					i += 3;  
				}  
			}  
			return string;  
		}  
}